/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  main.c
//  Active rectification for PFC stage 
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//  September 21th, 2011 - Version 1.00
//  Built with Code Composer Studio Core Edition Version: 5.1.1.00028
//
//	Device: MSP430F2012
//  P1.0  analog input      CURRENT
//  P2.6  digital input     NEUTRAL
//  P2.7  digital input     LINE
//  P1.3  digital output    LS_B = high  (default)
//  P1.4  digital output    LS_A = high  (default)
//  P1.1  PWM output        HS_B_1 = off (default)
//  P1.6  PWM output        HS_B_2 = off (default)
//  P1.2  PWM output        HS_A_1 = off (default)
//  P1.5  PWM output        HS_A_2 = off (default)
//
//******************************************************************************


#include "main.h"



unsigned int start_delay = 0;					// used for the start up delay
volatile unsigned int counter_25us = 0;			// used for 2.5us interrupt
volatile signed int current_state = 0;			// variable for current level
volatile signed int neutral_state = 0;			// variable for state of neutral
volatile signed int line_state = 0;				// variable for state of line
volatile unsigned int sampling_finished = 0;    // flag is set each 25us
volatile unsigned int MOSFET_on = 0;			// flag is set if MOSFETs are on

volatile unsigned int upper_threshold = 460;	// upper threshold for hysteresis
volatile unsigned int lower_threshold = 360;    // lower threshold for hysteresis



void main(void)
{  
   WDTCTL = WDTPW + WDTHOLD;  // stop watchdog
  
  _DINT();                    // stop all interrupts (general)
  
  
  // Delay of 100ms to be sure that the supply voltage reached 3.45V.
  // The clock frequency can only be set to 16 MHz when the supply
  // voltage is high enough.
  // The initial clock frequency is 1 MHz.
  __delay_cycles(100000);

  
  init_general();             // general initializations
  init_digital_outputs();     // initialization of digital outputs
  init_PWM_outputs();         // initialization of PWM outputs
  init_digital_inputs();      // initialization of digital inputs
  init_analog_input();        // initialization of analog input
  init_timerA();              // initialization of timerA for PWM
  
  
  // Switch all outputs off
  HS_A_1_off; HS_A_2_off;
  HS_B_1_off; HS_B_2_off;
  LS_A_off;
  LS_B_off;


  _EINT();                    // enable interrupts (general)
  
  
  
  // 2s delay to ensure proper startup of the PFC
  while(start_delay < 9)
  {
  	// interrupt 40000 times executed -> equals 100ms
  	if(counter_25us > 39999)
  	{
  		counter_25us = 0;
  		start_delay++;
  	}
  }
  
  counter_25us = 0;    // reset counter
  
  
    
  for (;;)
  {
  	
  	// executed every 25us (9 = 25us)
    if(counter_25us > 9)
    {
      counter_25us = 0;    // reset counter
      
      
      // Read analog current input
      // If the analog input is higher than 10% of the reference voltage (2.5V),
      // current_state is incremented.
      // If the analog input is lower than 10% of the reference voltage (2.5V),
      // current_state is decremented.
      // This value cannot be smaller than 0 or bigger than 3.
      // 1 LSB = 2.44mV, 10% = 102 LSB = 249mV
      // A hysteresis of 10% of the threshold is implemented:
      // lower threshold: 90 LSB, upper threshold: 110 LSB
      //
      // MOSFETs are switched off -> higher threshold is used
      // MOSFETs are switched on -> lower threshold is used
      if( (!MOSFET_on) && (ADC10MEM > upper_threshold) )
        current_state++;
      else if ( (MOSFET_on) && (ADC10MEM > lower_threshold) )
        current_state++;
      else
        current_state--;
      
      // limit range of current_state to 0...3
      if(current_state > 3) current_state = 3;
      if(current_state < 0) current_state = 0;
      
      
      // Read digital input (line, neutral)
      // If the digital input is high, neutral_state/line_state is incremented.
      // If the digital input is low, neutral_state/line_state is decremented.
      // These values cannot be smaller than 0 or bigger than 3.
      if(NEUTRAL_high)
        neutral_state++;
      else
        neutral_state--;
      
      if(LINE_high)
        line_state++;
      else
        line_state--;
      
      // limit range of neutral_state/line_state to 0...3
      if(neutral_state > 3) neutral_state = 3;
      if(neutral_state < 0) neutral_state = 0;
      if(line_state > 3) line_state = 3;
      if(line_state < 0) line_state = 0;
      
      
      // set flag for analysis of sampled inputs
      sampling_finished = 1;
      
      
      // Start AD-conversion
      // The conversion takes 13 ADC10CLKs + 16 sampling clocks.
      // ADC10CLK = MCLK = 16 MHz
      // ->  1 CLK = 62.5 ns 
      // -> 29 CLK = 1.8125 us
      // enable conversion
      set_bit(ADC10CTL0, ENC);
      // start AD conversion     
      set_bit(ADC10CTL0, ADC10SC);
    }
    
    
    
    // Analysis of sampled inputs
    if(sampling_finished)
    {
      // reset flag
      sampling_finished = 0;
      
      
      // First condition:
      // The current has to be higher than 10% of Vref for the last 75us.       
      // Second condition:
      // If the neutral voltage was high for the last 75us, the line voltage
      // has to be low for the last 75us.
      if( (current_state == 3) && (neutral_state == 3) && (line_state == 0) )
      {
        LS_B_off;
        HS_A_1_off;
        HS_A_2_off;
        
        LS_A_on;
        HS_B_1_on;
        HS_B_2_on;
        
        MOSFET_on = 1;   // set flag for hysteresis
      }
      
      // First condition
      // The current has to be higher than 10% of Vref for the last 75us.
      // Second condition
      // If the line voltage was high for the last 75us, the neutral voltage
      // has to be low for the last 75us.
      else if( (current_state == 3) && (line_state == 3) && (neutral_state == 0) )
      {
        LS_A_off;
        HS_B_1_off;
        HS_B_2_off;
          
        LS_B_on;
        HS_A_1_on;
        HS_A_2_on;
        
        MOSFET_on = 1;   // set flag for hysteresis
      }
        
      // Switch everything off if no condition applies
      else
      {
        LS_A_off;
        HS_B_1_off;
        HS_B_2_off;
              
        LS_B_off;
        HS_A_1_off;
        HS_A_2_off;
        
        MOSFET_on = 0;   // clear flag for hysteresis
      }   
        
    }  // if(sampling_finished)
    
  }  // for (;;)
  
}  // void main(void)



// executed every 2.5us
#pragma vector = TIMERA0_VECTOR
__interrupt void TIMERA0_ISR(void)
{
 counter_25us++;     // increase counter
}
